(function() {
  //    FILE:Timereportdetailview
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 5/29/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'mobiscroll', 'moment', 'models/time/TimeModel', 'views/objectbrowser/ObjectFolderBrowserView', 'views/timereport/TimereportTravelExpenseView', 'models/objects/ObjectModel', 'json2xml', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, mobiscroll, Moment, TimeModel, ObjectFolderBrowserView, TimereportTravelExpenseView, ObjectModel) {
    var TimereportDetailView;
    return TimereportDetailView = class TimereportDetailView extends Backbone.View {
      initialize(usr, timereport, timereportCol, context, eventsCol, obj1, trType) {
        this.usr = usr;
        this.timereport = timereport;
        this.timereportCol = timereportCol;
        this.context = context;
        this.eventsCol = eventsCol;
        this.obj = obj1;
        this.trType = trType;
        this.timereport.on('change', this.update_timereport_html, this);
        this.timereport.on('commited', this.timereport_commited, this);
        this.timereport.on('commitedError', this.timereport_commited_error, this);
        this.time = new TimeModel();
        if (this.usr.__enabled_time_travel_expenses()) {
          this.travelView = new TimereportTravelExpenseView(this.usr, this.timereport, this.__show_only_te());
        }
        //if an involved is changed then we only commit those ones, if nothing happen in list then we submit all as usual
        return this.individualtimes = false;
      }

      // FOR FUTURE BINDING SCREEN
      // if @context is 'Adhoc' and @prj then @prj.on('project_booking_updated',@__adhoc_project_details_updated,@)
      attributes() {
        return {
          'data-role': 'page'
        };
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap .btn-submenu-timereport': 'subMenuTimeReportClicked',
          'tap .btn-timein-timereport': 'btnTimeClicked',
          'tap .btn-timeout-timereport': 'btnTimeClicked',
          'tap .btn-timein-timereport-all': 'btnTimeClicked',
          'tap .btn-timeout-timereport-all': 'btnTimeClicked',
          'tap .btn-name-timereport': 'btnNameClicked',
          'change .time': 'btnTimereportChanged',
          'tap #id-btn-addBreak': 'btnAddBreakClicked',
          'tap #id-btn-addBreakAll': 'btnAddBreakAllClicked',
          'tap #id-submit-break': 'btnSubmitBreakClicked',
          'tap .btn-break-name': 'btnNameBreakClicked',
          'tap .btn-timein-break': 'btnTimeBreakClicked',
          'tap .btn-timeout-break': 'btnTimeBreakClicked',
          'tap  #id-delete-break': 'btnDeleteTimeBreakClicked',
          'tap #id-btn-addExtra': 'btnAddExtraClicked',
          'tap #id-ul-extras > li > span': 'liExtraClicked',
          'tap .btn-done-extra': 'btnDoneExtraClicked',
          'tap .btn-delete-extra': 'btnDeleteExtraClicked',
          'tap #id-btn-add-involved-adhoc': 'btnAddInvolvedClicked',
          'tap .btn-set-reported-timereport': 'btnSetReportedInvolved',
          'change .activity-select-involved': 'selectActivityChanged',
          'tap #id-btn-save-tr': 'btnSaveClicked',
          'pageshow': 'update_timereport_html'
        };
      }

      render() {
        var ref, ref1, template, texts;
        template = Handlebars.templates['TimereportDetailView'];
        texts = new Object();
        texts.notePlaceHolder = "Write a Timereport (Day) Note";
        if (window.isCompany("rt1.tv")) {
          texts.notePlaceHolder = "Write a Produktionsbericht (Day) Note";
        }
        this.$el.html(template({
          context: this.context,
          usr: this.usr.toJSON(),
          title: (ref = this.timereport) != null ? (ref1 = ref.get('Timereport')) != null ? ref1.parentTitle : void 0 : void 0,
          travel: this.usr.__enabled_time_travel_expenses(),
          showOnlyTE: this.__show_only_te(),
          texts: texts,
          //  showAddInvolved: @__show_add_involved()
          //  isReadonly: @timereport?.get('Timereport')?.isReadonly
          allowReportingIntoNextDay: this.usr.__can_timereport_tomorrow()
        }));
        if (this.travelView) {
          this.$el.find("#divTimeReportDetail").append(this.travelView.render());
        }
        this.$el.attr('id', 'id-Timereport-Detail');
        if (!this.usr.__can_timereport_all()) {
          $('#id-btn-addBreakAll').hide();
        }
        return this.addSidePanel();
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      update_timereport_html(mdl) {
        var dayNote, dayStartsAt, extras, html, involved, timeBreak, title, ul, ulBreak, ulExtra, usesAMPM;
        if (mdl instanceof jQuery.Event && !this.timereport.get('Timereport')) {
          return;
        }
        if (this.timereport.get('Timereport')) {
          mdl = this.timereport;
        }
        //READ ONLY
        if (mdl.get('Timereport').isReadonly) {
          this.$el.find('#id-div-error').html('<p>This timereport is read only.</p>').show();
        }
        //# HIDING SPINNER
        this.$el.find('#id-spinner-all').hide();
        //TITLE HEADER
        title = mdl.get('Timereport').parentTitle;
        if (!title) {
          title = '-';
        }
        this.$el.find('#id-div-header > h1').text(title);
        //DAY NOTE TAB
        dayNote = mdl.get('Timereport').dayNote;
        if (dayNote) {
          this.$el.find('#id-timereport-dayNote').val(dayNote);
        }
        if (this.__show_only_te()) {
          //MENU
          this.$el.find('.li-tr').hide();
          //TABS
          this.$el.find('#divTimeReportInvolved').hide();
          this.$el.find('#divTimeReportBreaks').hide();
          this.$el.find('#divTimeReportExtras').hide();
          return this.$el.find('#divTimeReportTravel').show();
        } else {
          dayStartsAt = parseInt(this.usr.get('dayStartsAt'), 10);
          usesAMPM = parseInt(this.usr.get('usesAMPM'), 10);
          //INVOLVED TAB
          involved = mdl.get('Timereport').Involved;
          if (involved) {
            ul = $('#id-ul-timereport-involved');
            ul.empty();
            this.__update_involved_tab_html(ul, involved, dayStartsAt, usesAMPM);
          }
          // IF ADD INVOLVED ALLOWED THEN ADD BUTTON
          if (this.__show_add_involved() && this.$el.find('#id-btn-add-involved-adhoc').length !== 1) {
            html = '<br/><a href="#" data-role="button" id="id-btn-add-involved-adhoc">Add Involved</a>';
            this.$el.find('#divTimeReportInvolved').append(html);
            this.$el.find('#divTimeReportInvolved').trigger('create');
          }
          //# BREAK TAB
          ulBreak = $('#id-ul-timebreaks');
          if (ulBreak.attr('data-addBreak') !== '1') {
            timeBreak = mdl.get('Timereport').TimeBreak;
            if (timeBreak) {
              ulBreak.empty();
              this.__update_breaks_tab_html(ulBreak, timeBreak, dayStartsAt, usesAMPM);
            }
          }
          //# EXTRA TAB
          ulExtra = $('#id-ul-extras');
          if (ulExtra.attr('data-addExtra') !== '1') {
            extras = mdl.get('Timereport').Extra;
            if (extras) {
              ulExtra.empty();
              return this.__update_extras_tab_html(ulExtra, extras);
            }
          }
        }
      }

      __update_extras_tab_html(ulExtra, extras) {
        if (!_.isArray(extras) && extras) {
          extras = [extras];
        }
        //bufferAdded = JSON.parse(window.localStorage.getItem("TimereportAddedExtra"))
        //all = _.union(extras,bufferAdded)
        _.each(extras, function(e) {
          var div, li, note;
          li = `<li data-extraID=\"${e != null ? e.extraID : void 0}\" data-activityID=\"${e != null ? e.activityID : void 0}\" data-objectID=\"${e != null ? e.objectID : void 0}\" data-objectType=\"${e != null ? e.type : void 0}\" data-quantity=\"${e != null ? e.quantity : void 0}\" data-note=\"${e != null ? e.note : void 0}\">`;
          li += `<span class='quantity'>${e != null ? e.quantity : void 0}</span><span class='name'> ${e != null ? e.name : void 0}</span><span class='fwi-edit edit-right'/> `;
          div = '<div class="extra-info" style="display: none;">';
          div += `<input type=\"number\" class=\"input-quantity\" value=\"${e != null ? e.quantity : void 0}\" placeholder='Quantity'/>`;
          note = (e != null ? e.note : void 0) ? e.note : '';
          div += `<textarea placeholder='Extra Note'>${note}</textarea>`;
          div += '<div class="wrapper-btn"> <span class="btn btn-delete-extra"> Delete </span> <span class="btn btn-done-extra"> Done </span> </div>';
          div += '</div>';
          li += div + '</li>';
          return ulExtra.append(li);
        });
        ulExtra.listview('refresh');
        return ulExtra.trigger('create');
      }

      __update_breaks_tab_html(ulBreak, timeBreak, dayStartsAt, usesAMPM) {
        var desc, header, idBreak, li, options, that, timeIn, timeOut;
        that = this;
        if (_.isArray(timeBreak)) {
          _.each(timeBreak, function(tb) {
            var applyToAllInvolved, desc, header, idBreak, li, options, timeIn, timeOut;
            idBreak = tb.timeBreakID;
            header = tb.header;
            desc = tb.note;
            applyToAllInvolved = tb.applyToAllInvolved;
            timeIn = that.time.get_time_string_from_float(dayStartsAt, usesAMPM, tb.timeIn);
            timeOut = that.time.get_time_string_from_float(dayStartsAt, usesAMPM, tb.timeOut);
            li = `<li id=\"id-li-${idBreak}\">`;
            li += '<div data-role="controlgroup"  class="controlgroup">';
            li += `<a href='#' data-role='button' data-theme='f' id=\"btn-break-${idBreak}\"  class=\"btn-break-name\" data-applyToAllInvolved=\"${applyToAllInvolved}\" data-breakid=\"${idBreak}\" data-timeBreakID=\"${idBreak}\" data-header=\"${header}\" data-desc=\"${desc}\"   >${header} <br/><span class='description'><small>${desc}</small></span> <span class='fwi-edit' style='float: right'></span></a>`;
            li += `<a href='#' data-role='button' data-theme='g' id=\"btn-timeIn-${idBreak}\" data-mini='true' class=\"btn-timein-break\" data-header=\"${header}\"  data-input=\"#inputIn-${idBreak}\"    data-type='TI'>Time In: ${timeIn} </a>`;
            li += `<a href='#' data-role='button' data-theme='b' id=\"btn-timeOut-${idBreak}\" data-mini='true'  class=\"btn-timeout-break\" data-header=\"${header}\" data-input=\"#inputOut-${idBreak}\" data-type='TO'>Time Out: ${timeOut} </a>`;
            li += `<input type='hidden' class='time input-break-TimeIn' id=\"inputIn-${idBreak}\" data-target=\"#btn-timeIn-${idBreak}\" value=\"${timeIn}\"/><input type='hidden' class='time input-break-TimeOut' data-target=\"#btn-timeOut-${idBreak}\" id=\"inputOut-${idBreak}\" value=\"${timeOut}\"/>`;
            li += "</div>";
            li += '</li>';
            ulBreak.append(li);
            options = {
              theme: 'iOS',
              display: 'bottom'
            };
            if (usesAMPM === 0) {
              options['timeFormat'] = 'H:ii';
              options['timeWheels'] = 'Hii';
            }
            $(`#inputIn-${idBreak}`).mobiscroll().time(options);
            return $(`#inputOut-${idBreak}`).mobiscroll().time(options);
          });
        } else if (timeBreak) {
          idBreak = timeBreak.timeBreakID;
          header = timeBreak.header;
          desc = timeBreak.note;
          timeIn = that.time.get_time_string_from_float(dayStartsAt, usesAMPM, timeBreak.timeIn);
          timeOut = that.time.get_time_string_from_float(dayStartsAt, usesAMPM, timeBreak.timeOut);
          li = `<li id=\"id-li-${idBreak}\">`;
          li += '<div data-role="controlgroup"  class="controlgroup">';
          li += `<a href='#' data-role='button' data-theme='f' id=\"btn-break-${idBreak}\"  class=\"btn-break-name\" data-breakid=\"${idBreak}\" data-timeBreakID=\"${idBreak}\" data-header=\"${header}\" data-desc=\"${desc}\"    >${header} <br/><span class='description'><small>${desc}</small></span> <span class='fwi-edit' style='float: right'></span></a>`;
          li += `<a href='#' data-role='button' data-theme='g' id=\"btn-timeIn-${idBreak}\" data-mini='true' class=\"btn-timein-break\" data-header=\"${header}\"  data-input=\"#inputIn-${idBreak}\"   data-iconpos='right' data-type='TI'>Time In: ${timeIn}  </a>`;
          li += `<a href='#' data-role='button' data-theme='b' id=\"btn-timeOut-${idBreak}\" data-mini='true'  class=\"btn-timeout-break\" data-header=\"${header}\" data-input=\"#inputOut-${idBreak}\"   data-iconpos='right' data-type='TO'>Time Out: ${timeOut}</a>`;
          li += `<input type='hidden' class='time input-break-TimeIn' id=\"inputIn-${idBreak}\" data-target=\"#btn-timeIn-${idBreak}\" value=\"${timeIn}\"/><input type='hidden' class='time input-break-TimeOut' data-target=\"#btn-timeOut-${idBreak}\" id=\"inputOut-${idBreak}\" value=\"${timeOut}\"/>`;
          li += "</div>";
          li += '</li>';
          ulBreak.append(li);
          options = {
            theme: 'iOS',
            display: 'bottom'
          };
          if (usesAMPM === 0) {
            options['timeFormat'] = 'H:ii';
            options['timeWheels'] = 'Hii';
          }
          $(`#inputIn-${idBreak}`).mobiscroll().time(options);
          $(`#inputOut-${idBreak}`).mobiscroll().time(options);
        }
        ulBreak.listview('refresh');
        return ulBreak.trigger('create');
      }

      __update_involved_tab_html(ul, involved, dayStartsAt, usesAMPM) {
        var activities, disabled, involvedID, li, name, note, obj, optionsIn, optionsOut, sel, spanReported, strRep, that, timeIn, timeInValue, timeOut, timeOutStr, timeOutValue;
        that = this;
        obj = new ObjectModel(this.usr);
        if (_.isArray(involved)) {
          ul.append(this.__get_li_allTimes());
          _.each(involved, function(inv) {
            var activities, disabled, involvedID, li, name, note, sel, spanReported, strRep, timeIn, timeInValue, timeOut, timeOutStr, timeOutValue;
            name = inv.name;
            involvedID = inv.involvedID;
            if (!involvedID) {
              involvedID = 'myself';
            }
            note = inv.noteReported;
            timeInValue = that.time.get_time_string_from_float(dayStartsAt, usesAMPM, inv.timeInReported);
            timeOutValue = that.time.get_time_string_from_float(dayStartsAt, usesAMPM, inv.timeOutReported);
            if (timeInValue === timeOutValue) {
              timeIn = 'All Day';
              timeOut = 'All Day';
              timeInValue = "00:00";
              timeOutValue = "00:00";
            } else {
              timeIn = timeInValue;
              timeOut = timeOutValue;
            }
            disabled = '';
            timeOutStr = 'Time Out';
            spanReported = '<span class="span-dot-involved-not-reported"></span>';
            if (inv.isReadonly) {
              disabled = 'ui-state-disabled';
            }
            if (inv.outTimeGoesIntoNextDay === 1) {
              timeOutStr = 'Tomorrow Time Out';
            }
            if (inv.isReported) {
              spanReported = '<span class="span-dot-involved-reported"></span>';
            }
            li = `<li data-objectID=\"${inv.objectID}\" >`;
            li += '<div data-role="controlgroup"  class="controlgroup">';
            li += `<a href='#'  data-role='button' data-theme='f' id=\"btn-name-${involvedID}\"   class=\"btn-name-timereport ${disabled}\" data-name=\"${name}\" data-popup=\"#note-${involvedID}\" data-involvedID=\"${involvedID}\"  data-iconpos='right' data-type='AN'>${spanReported} ${name} <span class='fwi-edit' style='float: right'></span></a>`;
            li += `<a href='#' data-role='button'  data-theme='g' style=\"display:none;\" id=\"btn-timeIn-${involvedID}\"  data-mini='true' class=\"btn-timein-timereport ${disabled}\" data-name=\"${name}\" data-input=\"#inputIn-${involvedID}\" data-involvedID=\"${involvedID}\"  data-iconpos='right' data-type='TI'>Time In: ${timeIn} </a>`;
            li += `<a href='#' data-role='button'  data-theme='b' style=\"display:none;\" id=\"btn-timeOut-${involvedID}\" data-mini='true' class=\"btn-timeout-timereport ${disabled}\" data-name=\"${name}\" data-input=\"#inputOut-${involvedID}\" data-involvedID=\"${involvedID}\"  data-iconpos='right' data-type='TO'>${timeOutStr}: ${timeOut} </a>`;
            if (that.__show_set_booking_time()) {
              li += `<a href='#' data-role='button'  data-theme='c' style=\"display:none;\" id=\"btn-set-reported-${involvedID}\" data-mini='true' class=\"btn-set-reported-timereport ${disabled}\"   data-iconpos='right'>Set Time As Booked</a>`;
            }
            if (that.context === 'Adhoc') {
              activities = obj.get_object_activity(inv.objectID);
              if ((activities != null ? activities.length : void 0) > 0) {
                sel = "<select class='activity-select-involved'><option>Tap to Add Activity</option>";
                _.each(activities, function(act) {
                  var opt;
                  opt = `<option value=\"${act.activityID}\">${act.name}</option>`;
                  return sel += opt;
                });
                sel += "</select>";
                li += sel;
              }
            }
            if (disabled !== 'ui-state-disabled') {
              strRep = '';
              if (inv.isReported) {
                strRep = 'data-to-commit=YES';
              }
              li += `<input type='hidden' class='time input-involved-TimeIn' id=\"inputIn-${involvedID}\" data-target=\"#btn-timeIn-${involvedID}\" value=\"${timeInValue}\" ${strRep}/><input type='hidden' class='time input-involved-TimeOut' id=\"inputOut-${involvedID}\" data-target=\"#btn-timeOut-${involvedID}\" value=\"${timeOutValue}\" ${strRep}/>`;
              li += `<div style=\"display:none;\" id=\"note-${involvedID}\" class='div-note-textarea' ><textarea id=\"inputNote-${involvedID}\" data-target=\"#btn-name-${involvedID}\"  placeholder=\"Add Note for ${name}\">${note}</textarea></div></div>`;
            }
            li += "</div>";
            li += '</li>';
            return ul.append(li);
          });
        } else {
          name = involved.name;
          involvedID = involved.involvedID;
          if (!involvedID) {
            involvedID = 'myself';
          }
          note = involved.noteReported;
          timeInValue = that.time.get_time_string_from_float(dayStartsAt, usesAMPM, involved.timeInReported);
          timeOutValue = that.time.get_time_string_from_float(dayStartsAt, usesAMPM, involved.timeOutReported);
          if (timeInValue === timeOutValue) {
            timeIn = 'All Day';
            timeOut = 'All Day';
            timeInValue = "00:00";
            timeOutValue = "00:00";
          } else {
            timeIn = timeInValue;
            timeOut = timeOutValue;
          }
          timeOutStr = 'Time Out';
          disabled = '';
          spanReported = '<span class="span-dot-involved-not-reported"></span>';
          if (involved.isReadonly) {
            disabled = 'ui-state-disabled';
          }
          if (involved.outTimeGoesIntoNextDay === 1) {
            timeOutStr = 'Tomorrow Time Out';
          }
          if (involved.isReported) {
            spanReported = '<span class="span-dot-involved-reported"></span>';
          }
          li = `<li data-objectID=\"${involved.objectID}\" >`;
          li += '<div data-role="controlgroup"  class="controlgroup">';
          li += `<a href='#' data-role='button' data-theme='f' id=\"btn-name-${involvedID}\"  class=\"btn-name-timereport ${disabled}\" data-name=\"${name}\" data-popup=\"#note-${involvedID}\" data-involvedID=\"${involvedID}\"  data-iconpos='right' data-type='AN'>${spanReported} ${name}<span class='fwi-edit' style='float: right;display: none;'/></a>`;
          li += `<a href='#' data-role='button' data-theme='g' id=\"btn-timeIn-${involvedID}\" data-mini='true' class=\"btn-timein-timereport ${disabled}\" data-name=\"${name}\"  data-input=\"#inputIn-${involvedID}\" data-involvedID=\"${involvedID}\"  data-iconpos='right' data-type='TI'>Time In: ${timeIn} </a>`;
          li += `<a href='#' data-role='button' data-theme='b' id=\"btn-timeOut-${involvedID}\" data-mini='true'  class=\"btn-timeout-timereport ${disabled}\" data-name=\"${name}\" data-input=\"#inputOut-${involvedID}\" data-involvedID=\"${involvedID}\"  data-iconpos='right' data-type='TO'>${timeOutStr}: ${timeOut}  </a>`;
          //if that.__show_set_booking_time()
          //  li += "<a href='#' data-role='button'  data-theme='c'  id=\"btn-set-reported-#{involvedID}\" data-mini='true' class=\"btn-set-reported-timereport #{disabled}\"   data-iconpos='right'>Set Time As Booked</a>"
          if (that.context === 'Adhoc') {
            activities = obj.get_object_activity(inv.objectID);
            sel = "<select><option>Tap to Add Activity</option>";
            _.each(activities, function(act) {
              var opt;
              opt = `<option value=\"${act.activityID}\">${act.name}</option>`;
              return sel += opt;
            });
            sel += "</select>";
            li += sel;
          }
          if (disabled !== 'ui-state-disabled') {
            strRep = '';
            if (involved.isReported) {
              strRep = 'data-to-commit=YES';
            }
            li += `<div id=\"note-${involvedID}\" class='div-note-textarea' ><textarea id=\"inputNote-${involvedID}\" data-target=\"#btn-name-${involvedID}\" placeholder=\"Add Note for ${name}\">${note}</textarea></div>`;
            li += `<input type='hidden' class='time input-involved-TimeIn' id=\"inputIn-${involvedID}\" data-target=\"#btn-timeIn-${involvedID}\" value=\"${timeInValue}\" ${strRep}/><input type='hidden' class='time input-involved-TimeOut' data-target=\"#btn-timeOut-${involvedID}\" id=\"inputOut-${involvedID}\" value=\"${timeOutValue}\" ${strRep}/>`;
          }
          li += "</div>";
          li += '</li>';
          ul.append(li);
        }
        optionsIn = {
          theme: 'iOS',
          display: 'bottom',
          'setText': 'Today'
        };
        optionsOut = {
          theme: 'iOS',
          display: 'bottom',
          'setText': 'Today',
          'onClose': function(time, btnText, inst) {
            if (btnText === 'set') {
              return $(this).attr({
                'data-tomorrow': false
              });
            }
          }
        };
        //###CHANGE FOR 1 - PROFILE PROPERTIES OF ALLAN ARE INCORRECT
        if (this.usr.__can_timereport_tomorrow()) {
          optionsOut['button3'] = function(event) {
            return _.each($('.input-involved-TimeOut'), function(input) {
              var hr, min, target, valueText;
              if ($(input).mobiscroll('isVisible')) {
                target = $(input).attr('data-target');
                hr = String($(input).mobiscroll('getInst').temp[0]);
                min = String($(input).mobiscroll('getInst').temp[1]);
                if (min === '0') {
                  min = '00'; //FIXING DOUBLE 0 ON TOMORROW TIME OUT
                }
                valueText = hr + ':' + min;
                if (target === '#btn-timeOut-all') {
                  $('.input-involved-TimeOut').val(valueText);
                  $('.input-involved-TimeOut').attr({
                    'data-tomorrow': true
                  });
                  $('.input-involved-TimeOut').trigger('change');
                } else {
                  $(input).val(valueText);
                  $(input).attr({
                    'data-tomorrow': true
                  });
                  $(input).trigger('change');
                }
                return $(input).mobiscroll('hide');
              }
            });
          };
          optionsOut['button3Text'] = 'Next Day';
        }
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          optionsIn['timeFormat'] = 'H:ii';
          optionsIn['timeWheels'] = 'Hii';
          optionsOut['timeFormat'] = 'H:ii';
          optionsOut['timeWheels'] = 'Hii';
        }
        //ADD GLOBAL TIME SELECTOR
        $('.input-involved-TimeIn').mobiscroll().time(optionsIn);
        $('.input-involved-TimeOut').mobiscroll().time(optionsOut);
        //REFRESH ULS
        ul.listview('refresh');
        return ul.trigger('create');
      }

      btnNameClicked(event) {
        var btn, involvedID;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        if (btn.hasClass('ui-state-disabled')) {
          return;
        }
        //noteTarget = btn.attr 'data-popup'
        involvedID = btn.attr('data-involvedID');
        //if involvedID isnt 'all'

        //OPEN ALL TIMEIN / TIMEOUT
        $('.div-note-textarea').slideToggle('fast', function() {
          if ($(this).css('display') === 'inline-block') {
            return $(this).css('display', 'block');
          }
        });
        $('.btn-timein-timereport').slideToggle('fast', function() {
          if ($(this).css('display') === 'inline-block') {
            return $(this).css('display', 'block');
          }
        });
        $('.btn-timeout-timereport').slideToggle('fast', function() {
          if ($(this).css('display') === 'inline-block') {
            return $(this).css('display', 'block');
          }
        });
        $('.btn-set-reported-timereport').slideToggle('fast', function() {
          if ($(this).css('display') === 'inline-block') {
            return $(this).css('display', 'block');
          }
        });
        //CLOSING ALL
        $('#btn-timeIn-all').slideToggle('fast', function() {
          if ($(this).css('display') === 'inline-block') {
            return $(this).css('display', 'block');
          }
        });
        $('#btn-timeOut-all').slideToggle('fast', function() {
          if ($(this).css('display') === 'inline-block') {
            return $(this).css('display', 'block');
          }
        });
        //SETTING PROPER ICON EDIT
        return $('.btn-name-timereport span.fwi-edit').toggle();
      }

      btnNameBreakClicked(event) {
        var btn, desc, header, idBreak, targetInput, targetTextArea;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        header = btn.attr('data-header');
        desc = btn.attr('data-desc');
        idBreak = btn.attr('data-breakid');
        targetInput = '#id-input-titleBreak';
        targetTextArea = '#id-textarea-titleDesc';
        $(targetInput).val(header);
        $(targetTextArea).val(desc);
        $(targetInput).attr('data-header', header);
        $(targetTextArea).attr('data-desc', desc);
        $(targetInput).attr('data-breakid', idBreak);
        $(targetTextArea).attr('data-breakid', idBreak);
        $('#id-delete-break').attr('data-breakid', idBreak);
        $('#id-delete-break').show();
        $('#id-div-addBreak-form').show();
        $('#id-ul-timebreaks').hide();
        $('#id-btn-addBreak').hide();
        $('#id-btn-addBreakAll').hide();
        return $('#defaultBreakContainer').hide();
      }

      btnDeleteTimeBreakClicked(event) {
        var btn, idBreak, li, ul;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        idBreak = btn.attr('data-breakid');
        ul = $('#id-ul-timebreaks');
        li = $('#id-li-' + idBreak);
        li.remove();
        ul.listview('refresh');
        ul.trigger('create');
        $('#id-div-addBreak-form').hide();
        $('#id-delete-break').hide();
        ul.show();
        $('#id-btn-addBreak').show();
        if (this.usr.__can_timereport_all()) {
          $('#id-btn-addBreakAll').show();
        }
        return $('#defaultBreakContainer').show();
      }

      btnTimeClicked(event) {
        var arrTime, btn, hr, input, min, name, str, txt;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        if (btn.hasClass('ui-state-disabled')) {
          return;
        }
        name = btn.attr('data-name');
        input = btn.attr('data-input');
        arrTime = $(input).val().split(':');
        hr = arrTime[0];
        min = arrTime[1];
        $(input).mobiscroll('setValue', [hr, min], 0);
        $(input).mobiscroll('show');
        if (btn.attr('data-type') === 'TI') {
          str = 'Time In for ' + name;
        } else {
          str = 'Time Out for ' + name;
        }
        txt = str + ' ' + $('.dwv').text();
        return $('.dwv').html(txt);
      }

      btnTimeBreakClicked(event) {
        var btn, input;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        input = $(btn.attr('data-input'));
        return input.mobiscroll('show');
      }

      btnTimereportChanged(event) {
        var btnTarget, formatStr, input, str, ti, tiStr, to, toStr, tomorrow;
        input = $(event.currentTarget);
        btnTarget = input.attr('data-target');
        tomorrow = input.attr('data-tomorrow');
        if ($(btnTarget).attr('data-type') === 'TI') {
          str = 'Time In: ' + input.val();
          toStr = $('#inputOut-' + btnTarget.split('-')[2]).val();
          formatStr = 'H:mm';
          if (_.indexOf(toStr, 'M') !== -1) { //AMPM CHECK
            formatStr = 'h:mm A';
          }
          ti = Moment(input.val(), formatStr);
          to = Moment(toStr, formatStr);
          if (ti > to) {
            input.val(ti.format(formatStr)); //SET TIME IN INPUT
            to = ti.clone();
            to.add('m', 15);
            $('#inputOut-' + btnTarget.split('-')[2]).val(to.format(formatStr)); //SET TIME OUT INPUT
            $('#btn-timeOut-' + btnTarget.split('-')[2]).find('.ui-btn-text').html('Time Out: ' + to.format(formatStr)); //SET TIME OUT BUTTON
          }
          if (btnTarget === '#btn-timeIn-all') {
            $('.input-involved-TimeIn').val(ti.format(formatStr));
            $('.btn-timein-timereport').find('.ui-btn-text').html(str);
            $('.input-involved-TimeOut').val(to.format(formatStr));
            $('.btn-timeout-timereport').find('.ui-btn-text').html('Time Out: ' + to.format(formatStr));
            this.individualtimes = false; //  WE SET ALL INVOLVED
          } else {
            this.individualtimes = true; //INDIVIDUAL MODE
            //spanReported = '<span class="span-dot-involved-reported"></span>'
            //$(btnTarget).parents('li').children().find('.span-dot-involved-not-reported').addClass('span-dot-involved-reported').removeClass('span-dot-involved-not-reported')
            $(btnTarget).parents('li').addClass('isReported');
          }
        } else {
          if (tomorrow === "true") {
            str = 'Tomorrow Time Out: ';
          } else {
            str = 'Time Out: ';
            tiStr = $('#inputIn-' + btnTarget.split('-')[2]).val();
            formatStr = 'H:mm';
            if (_.indexOf(tiStr, 'M') !== -1) { //AMPM CHECK
              formatStr = 'h:mm A';
            }
            ti = Moment(tiStr, formatStr);
            to = Moment(input.val(), formatStr);
            if (ti > to) {
              ti.add('m', 15);
              input.val(ti.format(formatStr));
            }
          }
          str += input.val();
          if (btnTarget === '#btn-timeOut-all') {
            //$('.input-involved-TimeIn').val(ti.format(formatStr))
            // $('.btn-timein-timereport').find('.ui-btn-text').html(str)
            $('.input-involved-TimeOut').val(to.format(formatStr));
            $('.btn-timeout-timereport').find('.ui-btn-text').html(str);
            this.individualtimes = false;
          } else {
            this.individualtimes = true;
            //spanReported = '<span class="span-dot-involved-reported"></span>'
            //(btnTarget).parents('li').children().find('.span-dot-involved-not-reported').addClass('span-dot-involved-reported').removeClass('span-dot-involved-not-reported')
            $(btnTarget).parents('li').addClass('isReported');
          }
        }
        //# SUPER UGLY DIRTY THING TO CHECK IF IT's for individual Involved and then only commit those
        input.attr('data-to-commit', 'YES');
        return $(btnTarget).find('.ui-btn-text').html(str);
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        //DELETE BUFFER FOR IMAGE
        if (window.expense) {
          window.expense = null;
        }
        if (this.context === 'EventView') {
          this.e;
        }
        // window.localStorage.removeItem("TimereportAddedExtra")
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnAddBreakClickedBase(event, applyToAll) {
        var btn, selectedIndex, target, ul;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        target = btn.attr('data-target');
        $('#id-input-titleBreak').attr('data-breakid', 'new');
        $('#id-input-titleBreak').val('');
        $('#id-textarea-titleDesc').val('');
        $('#id-input-defaultBreak').val($('#select-native-1').val());
        $('#id-input-applyToAll').val(applyToAll);
        selectedIndex = parseInt($('#id-input-defaultBreak').val(), 10);
        if (selectedIndex >= 0) {
          $('#id-input-titleBreak').val(this.usr.__default_time_breaks()[selectedIndex].Name);
        }
        ul = $('#id-ul-timebreaks');
        ul.hide();
        $('#defaultBreakContainer').hide();
        $(target).show();
        $('#id-btn-addBreak').hide();
        return $('#id-btn-addBreakAll').hide();
      }

      //btn.hide()
      btnAddBreakClicked(event) {
        return this.btnAddBreakClickedBase(event, '0');
      }

      btnAddBreakAllClicked(event) {
        if (this.usr.__can_timereport_all()) {
          return this.btnAddBreakClickedBase(event, '1');
        } else {
          return this.btnAddBreakClickedBase(event, '0');
        }
      }

      btnSubmitBreakClicked(event) {
        var applyToAllInvolved, btn, dayStartsAt, desc, header, idBreak, li, options, selectedBreak, selectedIndex, timeIn, timeOut, ul, usesAMPM;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        header = $('#id-input-titleBreak').val();
        desc = json2xml.sanitize($('#id-textarea-titleDesc').val());
        dayStartsAt = parseInt(this.usr.get('dayStartsAt'), 10);
        usesAMPM = parseInt(this.usr.get('usesAMPM'), 10);
        timeIn = this.time.get_time_string_from_float(dayStartsAt, usesAMPM, dayStartsAt);
        timeOut = this.time.get_time_string_from_float(dayStartsAt, usesAMPM, dayStartsAt + 1);
        selectedIndex = parseInt($('#id-input-defaultBreak').val(), 10);
        applyToAllInvolved = $('#id-input-applyToAll').val();
        if (selectedIndex >= 0) {
          selectedBreak = this.usr.__default_time_breaks()[selectedIndex];
          timeIn = this.time.get_time_string_from_float(dayStartsAt, usesAMPM, selectedBreak.From);
          timeOut = this.time.get_time_string_from_float(dayStartsAt, usesAMPM, selectedBreak.To);
        }
        ul = $('#id-ul-timebreaks');
        /* SETTING ATTRIBUTE TO UL TO KNOW IS BEEN MODIFIED */
        ul.attr('data-addBreak', '1');
        if ($('#id-input-titleBreak').attr('data-breakid') === 'new') {
          idBreak = ul.find('li').length;
          li = `<li id=\"id-li-${idBreak}\">`;
          li += '<div data-role="controlgroup"  class="controlgroup">';
          li += `<a href='#' data-role='button' data-theme='f' id=\"btn-break-${idBreak}\"  class=\"btn-break-name\" data-applytoallinvolved=\"${applyToAllInvolved}\" data-breakid=\"${idBreak}\" data-timeBreakID='' data-header=\"${header}\" data-desc=\"${desc}\"  data-iconpos='right'  >${header} <br/><span class='description'><small>${desc}</small></span><span class='fwi-edit' style='float: right'></span></a>`;
          li += `<a href='#' data-role='button' data-theme='g' id=\"btn-timeIn-${idBreak}\" data-mini='true' class=\"btn-timein-break\" data-header=\"${header}\"  data-input=\"#inputIn-${idBreak}\"   data-iconpos='right' data-type='TI'>Time In: ${timeIn} </a>`;
          li += `<a href='#' data-role='button' data-theme='b' id=\"btn-timeOut-${idBreak}\" data-mini='true'  class=\"btn-timeout-break\" data-header=\"${header}\" data-input=\"#inputOut-${idBreak}\"   data-iconpos='right' data-type='TO'>Time Out: ${timeOut} </a>`;
          li += `<input type='hidden' class='time input-break-TimeIn' id=\"inputIn-${idBreak}\" data-target=\"#btn-timeIn-${idBreak}\" value=\"${timeIn}\"/><input type='hidden' class='time input-break-TimeOut' data-target=\"#btn-timeOut-${idBreak}\" id=\"inputOut-${idBreak}\" value=\"${timeOut}\"/>`;
          li += "</div>";
          li += '</li>';
          ul.append(li);
          options = {
            theme: 'iOS',
            display: 'bottom'
          };
          if (usesAMPM === 0) {
            options['timeFormat'] = 'H:ii';
            options['timeWheels'] = 'Hii';
          }
          $(`#inputIn-${idBreak}`).mobiscroll().time(options);
          $(`#inputOut-${idBreak}`).mobiscroll().time(options);
        } else {
          idBreak = $('#id-input-titleBreak').attr('data-breakid');
          btn = $('#btn-break-' + idBreak);
          btn.attr('data-header', header);
          btn.attr('data-desc', desc);
          //btn.attr('id','btn-break-'+idBreak)
          btn.find('.ui-btn-text').html(header + `<br/><span class='description'><small>${desc}</small></span><span class='fwi-edit' style='float: right'></span>`);
        }
        ul.listview('refresh');
        ul.trigger('create');
        $('#id-div-addBreak-form').hide();
        $('#id-delete-break').hide();
        ul.show();
        $('#id-btn-addBreak').show();
        if (this.usr.__can_timereport_all()) {
          $('#id-btn-addBreakAll').show();
        }
        return $('#defaultBreakContainer').show();
      }

      liExtraClicked(event) {
        var extra, icon, li, span;
        event.preventDefault();
        event.stopPropagation();
        span = $(event.currentTarget);
        li = span.parent();
        extra = li.find('.extra-info');
        icon = li.find('.edit-right');
        if (extra.is(":visible")) {
          icon.removeClass('fwi-cross-cancel').addClass('fwi-edit');
        } else {
          icon.removeClass('fwi-edit').addClass('fwi-cross-cancel');
          if (li.attr('data-note') === !"undefined") {
            li.find('textarea').val(li.attr('data-note'));
          }
        }
        return extra.toggle();
      }

      btnAddExtraClicked(event) {
        var nextView;
        event.preventDefault();
        event.stopPropagation();
        if (!ObjectFolderBrowserView) {
          ObjectFolderBrowserView = require('views/objectbrowser/ObjectFolderBrowserView');
        }
        nextView = new ObjectFolderBrowserView(this.usr, 'TimereportExtra');
        return $.mobile.jqmNavigator.pushView(nextView, {
          transition: 'none'
        });
      }

      btnDoneExtraClicked(event) {
        var btn, extra, icon, li, note, quantity;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        li = btn.parents('li');
        quantity = li.find('input').val();
        note = li.find('textarea').val();
        //SPAN UPDATE
        li.find('span.quantity').text(quantity);
        li.attr('data-quantity', quantity);
        li.attr('data-note', note);
        extra = li.find('.extra-info');
        icon = li.find('.edit-right');
        if (extra.is(":visible")) {
          icon.removeClass('fwi-cross-cancel').addClass('fwi-edit');
        } else {
          icon.removeClass('fwi-edit').addClass('fwi-cross-cancel');
        }
        return extra.toggle();
      }

      btnDeleteExtraClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        //DELETE LI
        $(event.currentTarget).parents('li').remove();
        return $('#id-ul-extras').listview('refresh');
      }

      btnSetReportedInvolved(event) {
        var btn;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        this.individualtimes = true;
        btn.siblings('input').attr('data-to-commit', 'YES');
        //spanReported = '<span class="span-dot-involved-reported"></span>'
        //btn.parents('li').children().find('.span-dot-involved-not-reported').addClass('span-dot-involved-reported').removeClass('span-dot-involved-not-reported')
        return btn.parents('li').addClass('isReported');
      }

      btnAddInvolvedClicked(event) {
        var nextView;
        event.preventDefault();
        event.stopPropagation();
        if (!ObjectFolderBrowserView) {
          ObjectFolderBrowserView = require('views/objectbrowser/ObjectFolderBrowserView');
        }
        nextView = new ObjectFolderBrowserView(this.usr, 'AdhocInvolved');
        return $.mobile.jqmNavigator.pushView(nextView, {
          transition: 'none'
        });
      }

      addedAdhocInvolved(view, objMdl) {
        var dayStartsAt, involved, ul, usesAMPM;
        involved = {
          activityID: '',
          classID: objMdl.get('objectClassID'),
          involvedID: 'new' + Math.floor(Math.random() * 100),
          objectID: objMdl.get('objectID'),
          name: objMdl.get('objectName'),
          type: objMdl.get('objectType'),
          noteReported: '',
          outTimeGoesIntoNextDay: "",
          timeInReported: "",
          timeOutReported: "",
          timeunitQuantityReported: ""
        };
        if (!view.timereport.get('Timereport').Involved) {
          view.timereport.get('Timereport').Involved = [];
        }
        if (!_.isArray(view.timereport.get('Timereport').Involved)) {
          view.timereport.get('Timereport').Involved = [view.timereport.get('Timereport').Involved];
        }
        view.timereport.get('Timereport').Involved.push(involved);
        dayStartsAt = parseInt(view.usr.get('dayStartsAt'), 10);
        usesAMPM = parseInt(view.usr.get('usesAMPM'), 10);
        ul = view.$el.find('#id-ul-timereport-involved');
        ul.empty();
        view.__update_involved_tab_html(ul, view.timereport.get('Timereport').Involved, dayStartsAt, usesAMPM);
        //COMING BACK TO TASK VIEW FROM OBJECT BRWOSER
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      selectActivityChanged(event) {
        var activityID, objectID;
        event.preventDefault();
        event.stopPropagation();
        activityID = $(event.currentTarget).val();
        objectID = $(event.currentTarget).closest('li').attr('data-objectID');
        return _.each(this.timereport.get('Timereport').Involved, function(inv) {
          if (inv.objectID === objectID) {
            inv.activityID = activityID;
          }
        });
      }

      //console.log @timereport.toJSON()
      btnSaveClicked(event) {
        var dayStartsAt, iNote, iObj, inputIn, inputOut, inv, involvedID, nextDay, noteInv, objectID, ref, requestObject, tIn, tOut, timeInInv, timeOutInv, tr;
        event.preventDefault();
        event.stopPropagation();
        tr = this.timereport.get('Timereport');
        requestObject = new Object();
        requestObject.sessionID = this.usr.get('sessionID');
        requestObject.day = tr.day;
        if (tr.TravelExpenseSheet) {
          requestObject.day = Moment(tr.TravelExpenseSheet.startDateAndTime).format('YYYY-MM-DD');
        }
        requestObject.dayNote = $('#id-timereport-dayNote').val() ? $('#id-timereport-dayNote').val() : "";
        requestObject.bookingID = tr.bookingID;
        requestObject.isAdhoc = tr.isAdhoc;
        requestObject.trType = this.trType;
        if (tr.isAdhoc) {
          requestObject.adhocProjectID = (ref = tr.adhocProjectID) != null ? ref : "";
        }
        requestObject.Involved = new Array();
        requestObject.Extras = new Array();
        requestObject.TimeBreak = new Array();
        dayStartsAt = parseInt(this.usr.get('dayStartsAt'), 10);
        if (!this.__show_only_te()) {
          if (_.isArray(tr.Involved)) {
            if (this.__should_send_involved_to_commit()) {
              _.each(tr.Involved, (inv) => {
                var iNote, iObj, inputIn, inputOut, involvedID, nextDay, noteInv, objectID, tIn, tOut, timeInInv, timeOutInv;
                involvedID = inv.involvedID;
                if (!involvedID) {
                  involvedID = 'myself';
                }
                objectID = inv.objectID;
                nextDay = 0;
                inputIn = $('#inputIn-' + involvedID);
                inputOut = $('#inputOut-' + involvedID);
                if ((inputIn != null ? inputIn.attr('data-to-commit') : void 0) === 'YES' || inputOut.attr('data-to-commit') === 'YES' || this.individualtimes === false) {
                  if (inputIn != null ? inputIn.val() : void 0) {
                    tIn = inputIn != null ? inputIn.val() : void 0;
                  } else {
                    tIn = inv.timeInReported;
                  }
                  if (inputOut.val()) {
                    tOut = inputOut.val();
                    if ((inputOut != null ? inputOut.attr('data-tomorrow') : void 0) === 'true') {
                      nextDay = 1;
                    }
                  } else {
                    tOut = inv.timeOutReported;
                    if (inv.outTimeGoesIntoNextDay) {
                      nextDay = 1;
                    }
                  }
                  if ($('#inputNote-' + involvedID).val()) {
                    iNote = $('#inputNote-' + involvedID).val();
                  } else {
                    iNote = inv.noteReported;
                  }
                  noteInv = window.html_entities(window.__check_undefined(iNote));
                  timeInInv = this.time.get_float_from_time_string(dayStartsAt, tIn);
                  timeOutInv = this.time.get_float_from_time_string(dayStartsAt, tOut);
                  if (timeInInv === -dayStartsAt && timeOutInv === -dayStartsAt) {
                    timeInInv = 0;
                    timeOutInv = 24;
                  }
                  //SUPER CHECK IF IT WAS ADDED AS AN INVOLVED LATER IN THE TIMEREPORT
                  if (involvedID.indexOf('new') > -1) {
                    involvedID = '';
                  }
                  iObj = {
                    'objectID': objectID,
                    'involvedID': involvedID,
                    'type': inv.type,
                    'timeunitQuantityReported': inv.timeunitQuantityReported,
                    'activityID': inv.activityID,
                    'noteReported': noteInv,
                    'timeInReported': timeInInv,
                    'timeOutReported': timeOutInv,
                    'classID': inv.classID,
                    'outTimeGoesIntoNextDay': nextDay
                  };
                  return requestObject.Involved.push(iObj);
                }
              });
            }
          } else if (tr.Involved) {
            inv = tr.Involved;
            involvedID = inv.involvedID;
            if (!involvedID) {
              involvedID = 'myself';
            }
            objectID = inv.objectID;
            inputIn = $('#inputIn-' + involvedID);
            inputOut = $('#inputOut-' + involvedID);
            nextDay = 0;
            if ((inputIn != null ? inputIn.attr('data-to-commit') : void 0) === 'YES' || inputOut.attr('data-to-commit') === 'YES' || this.individualtimes === false) {
              if (inputIn != null ? inputIn.val() : void 0) {
                tIn = inputIn.val();
              } else {
                tIn = inv.timeInReported;
              }
              if (inputOut.val()) {
                tOut = inputOut.val();
                if ((inputOut != null ? inputOut.attr('data-tomorrow') : void 0) === 'true') {
                  nextDay = 1;
                }
              } else {
                tOut = inv.timeOutReported;
                if (inv.outTimeGoesIntoNextDay) {
                  nextDay = 1;
                }
              }
              if ($('#inputNote-' + involvedID).val()) {
                iNote = $('#inputNote-' + involvedID).val();
              } else {
                iNote = inv.noteReported;
              }
              noteInv = window.html_entities(window.__check_undefined(iNote));
              timeInInv = this.time.get_float_from_time_string(dayStartsAt, tIn);
              timeOutInv = this.time.get_float_from_time_string(dayStartsAt, tOut);
              if (timeInInv === -dayStartsAt && timeOutInv === -dayStartsAt) {
                timeInInv = 0;
                timeOutInv = 24;
              }
              iObj = {
                'objectID': objectID,
                'involvedID': involvedID,
                'type': inv.type,
                'timeunitQuantityReported': inv.timeunitQuantityReported,
                'activityID': inv.activityID,
                'noteReported': noteInv,
                'timeInReported': timeInInv,
                'timeOutReported': timeOutInv,
                'classID': inv.classID,
                'outTimeGoesIntoNextDay': nextDay
              };
              requestObject.Involved.push(iObj);
            }
          }
          //BREAKS
          _.each($('.btn-break-name'), (brk) => {
            var applyToAllInvolved, idBreak, obj, timeBreakID, timeIn, timeOut;
            idBreak = window.__check_undefined($(brk).attr('data-breakid'));
            timeBreakID = window.__check_undefined($(brk).attr('data-TimeBreakID'));
            timeIn = this.time.get_float_from_time_string(dayStartsAt, $('#inputIn-' + idBreak).val());
            timeOut = this.time.get_float_from_time_string(dayStartsAt, $('#inputOut-' + idBreak).val());
            obj = {
              'header': $(brk).attr('data-header'),
              'note': $(brk).attr('data-desc'),
              'timeIn': timeIn,
              'timeOut': timeOut,
              'timeBreakID': timeBreakID
            };
            applyToAllInvolved = window.__check_undefined($(brk).attr('data-applyToAllInvolved'));
            if (applyToAllInvolved !== '') {
              obj.applyToAllInvolved = applyToAllInvolved;
            }
            return requestObject.TimeBreak.push(obj);
          });
          //EXTRAS
          _.each($('#id-ul-extras > li'), (extra) => {
            var activityID, idExtra, name, note, obj, quantity, type;
            idExtra = window.__check_undefined($(extra).attr('data-extraID'));
            objectID = window.__check_undefined($(extra).attr('data-objectID'));
            type = $(extra).attr('data-objectType');
            quantity = $(extra).attr('data-quantity');
            note = window.html_entities(window.__check_undefined($(extra).attr('data-note')));
            name = $(extra).find('.name').text();
            activityID = window.__check_undefined($(extra).attr('data-activityID'));
            obj = {
              'extraID': idExtra,
              'objectID': objectID,
              'type': type,
              'quantity': quantity,
              'name': name,
              'note': note,
              'activityID': activityID
            };
            return requestObject.Extras.push(obj);
          });
        }
        return this.timereport.save_timereport(requestObject, this.usr);
      }

      // @timereportCol.get_not_done_timereports(@usr)
      timereport_commited(mdl) {
        var title;
        if (this.context !== 'Adhoc') {
          this.timereportCol.trigger('commitedTimeReport');
          return $.mobile.jqmNavigator.popView({
            transition: 'none'
          });
        } else {
          this.eventsCol.set_day_events(this.usr, this.timereport.get('Timereport').day, this.obj);
          if (!this.obj) {
            title = this.usr.get('usersFullName');
          } else {
            title = this.obj.get('name');
          }
          $('#id-h1-navbar-title').text(title);
          return $.mobile.jqmNavigator.popToFirst({
            transition: 'none'
          });
        }
      }

      timereport_commited_error(mdl) {
        var errorMsg, errorObj;
        errorObj = this.timereport.get('errorResult');
        errorMsg = errorObj.errorText;
        if (errorObj.error === "allowReportingOverExistingReportedTime") {
          errorMsg = `The Times Are Already Reported ${errorObj.errorText}`;
        }
        if (errorObj.error === "mandatoryNoteForObjectWhenReportingOvertime") {
          errorMsg = `Note Required ${errorObj.errorText}`;
        }
        if (errorObj.error === "mandatoryTravelExpenseField") {
          errorMsg = `Missing Required Field ${errorObj.errorText}`;
        }
        if (errorObj.error === "nonValidTravelExpenseCPR") {
          errorMsg = "Required CPR Number";
        }
        $('#id-div-error').html('<p>' + errorMsg + '</p>');
        return $('#id-div-error').show();
      }

      subMenuTimeReportClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        $('.subTimeReportDetailView').hide();
        return $(id).show();
      }

      __get_timereport_allTime(type) {
        var dayStartsAt, involved, tr, usesAMPM;
        //GET INVOLVED OBJETS (IF MORE THAN ONE PICK FIRST)
        dayStartsAt = parseInt(this.usr.get('dayStartsAt'), 10);
        usesAMPM = parseInt(this.usr.get('usesAMPM'), 10);
        tr = this.timereport.get("Timereport");
        if (tr) {
          if (_.isArray(tr.Involved)) {
            involved = tr.Involved[0];
          } else {
            involved = tr.Involved;
          }
          if (type === 'TI') {
            return this.time.get_time_string_from_float(dayStartsAt, usesAMPM, involved.timeInReported);
          } else if (type === 'TO') {
            return this.time.get_time_string_from_float(dayStartsAt, usesAMPM, involved.timeOutReported);
          }
        }
      }

      __get_li_allTimes() {
        var allTimeIn, allTimeOut, disabled, involved, li, ti, timeInValue, timeOutValue, to;
        timeInValue = this.__get_timereport_allTime('TI');
        timeOutValue = this.__get_timereport_allTime('TO');
        disabled = '';
        if (this.timereport.get('Timereport').isReadonly) {
          disabled = 'ui-state-disabled';
        }
        if (timeInValue === timeOutValue) {
          ti = 'All Day';
          to = 'All Day';
          timeInValue = "00:00";
          timeOutValue = "00:00";
        } else {
          ti = timeInValue;
          to = timeOutValue;
        }
        involved = this.timereport.get('Timereport').Involved;
        allTimeIn = _.uniq(_.pluck(involved, "timeInReported"));
        allTimeOut = _.uniq(_.pluck(involved, "timeOutReported"));
        // IF WE HAVE DIFFERENT TIMEIN-TIMEOUT IN INVOLVED THEN IS ALSO INDIVIDUALTIME SCENARIO
        if ((allTimeIn.length > 1) || (allTimeOut.length > 1)) {
          ti = "Mixed";
          to = "Mixed";
        }
        li = '<li>';
        li += '<div data-role="controlgroup"  class="controlgroup">';
        li += `<a href='#' data-role='button' id='btn-name-all'     data-theme='f' class=\"btn-name-timereport ${disabled}\"  data-iconpos='right' data-involvedID='all' data-type='AN' >All Involved <span class='fwi-edit' style='float: right;display: none;'/></a>`;
        li += `<a href='#' data-role='button' id='btn-timeIn-all'  data-theme='g' data-mini='true'  class=\"btn-timein-timereport-all ${disabled}\" data-input='#inputIn-all' data-involvedID='all' data-name='All'  data-iconpos='right' data-type='TI'>Time In: ${ti} </a>`;
        li += `<a href='#' data-role='button' id='btn-timeOut-all' data-theme='b' data-mini='true'  class=\"btn-timeout-timereport-all ${disabled}\"  data-input='#inputOut-all' data-involvedID='all' data-name='All'  data-iconpos='right' data-type='TO'>Time Out: ${to} </a>`;
        li += `<input type='hidden' class='time input-involved-TimeIn' id='inputIn-all'  data-target='#btn-timeIn-all' value=\"${timeInValue}\"/>`;
        li += `<input type='hidden' class='time input-involved-TimeOut' id='inputOut-all' data-target='#btn-timeOut-all' value=\"${timeOutValue}\"/>`;
        li += '</div></li>';
        return li;
      }

      __show_only_te() {
        var ref;
        if (this.usr.__can_timereport_all_projects()) {
          return false;
        }
        if (this.usr.__can_timereport_in_his_division_projects()) {
          return false;
        }
        if (this.usr.__can_timereport_relation_projects()) {
          return false;
        }
        if (this.usr.__enabled_time_travel_expenses()) {
          if ((ref = this.timereport.get('Timereport')) != null ? ref.isAdhoc : void 0) {
            return true;
          } else {
            return false;
          }
        }
        return false;
      }

      __show_add_involved() {
        var ref, ref1;
        //unless @timereport.get('Timereport')?.isAdhoc then return false
        if ((ref = this.timereport.get('Timereport')) != null ? ref.isReadonly : void 0) {
          return false;
        }
        if (!((ref1 = this.timereport.get('Timereport')) != null ? ref1.isAdhoc : void 0)) {
          return false;
        }
        return true;
      }

      __show_set_booking_time() {
        var allobjIDS, involved, noRepeated;
        if (this.individualtimes) {
          true;
        }
        involved = this.timereport.get('Timereport').Involved;
        if (_.isArray(involved)) {
          allobjIDS = _.pluck(involved, "objectID");
          noRepeated = _.uniq(allobjIDS);
          // allTimeIn = _.uniq(_.pluck(involved,"timeInReported"))
          // allTimeOut = _.uniq(_.pluck(involved,"timeOutReported"))
          //IF WE HAVE DIFFERENT TIMEIN-TIMEOUT IN INVOLVED THEN IS ALSO INDIVIDUALTIME SCENARIO
          // if (allTimeIn.length > 1) or (allTimeOut.length > 1) then return true
          if (allobjIDS.length > noRepeated.length) {
            return true;
          }
        }
        return false;
      }

      __should_send_involved_to_commit() {
        var allobjIDS, involved, noRepeated, repeatedInv;
        repeatedInv = false;
        involved = this.timereport.get('Timereport').Involved;
        if (_.isArray(involved)) {
          allobjIDS = _.pluck(involved, "objectID");
          noRepeated = _.uniq(allobjIDS);
          //  allTimeIn = _.uniq(_.pluck(involved,"timeInReported"))
          //  allTimeOut = _.uniq(_.pluck(involved,"timeOutReported"))
          if (allobjIDS.length > noRepeated.length) {
            repeatedInv = true;
          }
        }
        // IF WE HAVE DIFFERENT TIMEIN-TIMEOUT IN INVOLVED THEN IS ALSO INDIVIDUALTIME SCENARIO
        //   if (allTimeIn.length > 1) or (allTimeOut.length > 1) then repeatedInv = true

        //IF NOT REPEATED INVOLVED , ALLOW COMMIT
        if (!repeatedInv) {
          return true;
        }
        //IF REPEATED AND INDIVIDUAL TIME TRUE THEN COMMMIT
        if (repeatedInv && this.individualtimes) {
          return true;
        } else {
          //ELSE WE DONT ALLOW COMMIT INVOLVED
          return false;
        }
      }

    };
  });

}).call(this);
